$(function() {
	var poll_input = $( "#poll_input" );;
	var input_type;
	
	var	tips = $( ".validateTips" );

	function updateTips( t ) {
		tips
			.text( t )
			.addClass( "ui-state-highlight" );
		setTimeout(function() {
			tips.removeClass( "ui-state-highlight", 1500 );
		}, 500 );
	}

	function checkRegexp( o, regexp, n ) {
		if ( !( regexp.test( o.val() ) ) ) {
			o.addClass( "ui-state-error" );
			updateTips( n );
			return false;
		} else {
			return true;
		}
	}

	$( "#dialog-form" ).dialog({
		autoOpen: false,
		height: 'auto',
		width: 350,
		resizable: false,
		draggable: false,
		hide: 'blind',
		show: 'blind',
		modal: true,
		buttons: {
			"OK": function() {
				var bValid = true;
				poll_input.removeClass( "ui-state-error" );
				
				if(input_type=="title_color"){
					bValid = bValid && checkRegexp( poll_input, /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/i, "You have to enter a valid hex color code.  e.g. #000000" );
				}
				else if(input_type=="bg_color"){
					bValid = bValid && checkRegexp( poll_input, /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/i, "You have to enter a valid hex color code.  e.g. #000000" );
				}
				else if(input_type=="change_username"){
					bValid = bValid && checkRegexp( poll_input, /^[^<>$#"]*$/i, "You have to enter a valid username." ); 
				}	
				else if(input_type=="change_password"){
					bValid = bValid && checkRegexp( poll_input, /^[^<>$#"]*$/i, "You have to enter a valid password." ); 
				}								
				else if(input_type=="new_poll"){
					bValid = bValid && checkRegexp( poll_input, /^[^<>$#"]*$/i, "You have to enter a valid title for the poll." ); 
				}
				else if(input_type=="edit_title"){
					bValid = bValid && checkRegexp( poll_input, /^[^<>$#"]*$/i, "You have to enter a valid title for the poll." ); 
				}				
				else if(input_type=="new_website"){
					bValid = bValid && checkRegexp( poll_input, /^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/i, "You have to enter a correct URL." );
				}
				else if(input_type=="new_option"){
					bValid = bValid && checkRegexp( poll_input, /^[^<>$#"]*$/i, "You have to enter a valid option for the poll." );
				}								

				if ( bValid && input_type=="new_poll" ) {
					if(poll_input.val()!=""){
					window.location = "add_poll.php?poll_title="+poll_input.val().replace(/'/g,"\\'"); }
					$( this ).dialog( "close" );
				}
				
				else if ( bValid && input_type=="edit_title" ) {
					if(poll_input.val()!=""){
					window.location = "edit_title.php?poll_id="+$( "#edit_title" ).attr("name")+"&&poll_title="+poll_input.val().replace(/'/g,"\\'"); }
					$( this ).dialog( "close" );
				}
				
				else if ( bValid && input_type=="change_username" ) {
					if(poll_input.val()!=""){
					window.location = "change_username.php?id="+$( "#change_username" ).attr("name")+"&&username="+poll_input.val().replace(/'/g,"\\'"); }
					$( this ).dialog( "close" );
				}	
				
				else if ( bValid && input_type=="change_password" ) {
					if(poll_input.val()!=""){
					window.location = "change_userpassword.php?id="+$( "#change_password" ).attr("name")+"&&password="+poll_input.val().replace(/'/g,"\\'"); }
					$( this ).dialog( "close" );
				}									
				
				else if ( bValid && input_type=="new_website" ) {
					window.location = "add_website.php?defined_website="+poll_input.val();
					$( this ).dialog( "close" );
				}
				
				else if ( bValid && input_type=="new_option" ) {
					window.location = "add_option.php?poll_id="+$( "#new_option" ).attr("name")+"&&poll_option="+poll_input.val().replace(/'/g,"\\'");
					$( this ).dialog( "close" );
				}	
				
				else if ( bValid && input_type=="title_color" ) {
					window.location = "edit_titlecolor.php?poll_id="+$( "#edit_titlecolor" ).attr("name")+"&&title_color="+poll_input.val().replace("#","");
					$( this ).dialog( "close" );
				}
				
				else if ( bValid && input_type=="bg_color" ) {
					window.location = "edit_bgcolor.php?poll_id="+$( "#edit_bgcolor" ).attr("name")+"&&bg_color="+poll_input.val().replace("#","");
					$( this ).dialog( "close" );
				}											
			},
			Cancel: function() {
				$( this ).dialog( "close" );
			}
		},
		close: function() {
			poll_input.val( "" ).removeClass( "ui-state-error" );
		}
	});
	
	$( "#change_username" )
		.click(function() {
			input_type = "change_username";
			$( ".validateTips" ).text("You can change the username as you wish");
			$( "#poll_input" ).attr("value",$( "#change_username" ).attr("title"));
			$("span.ui-dialog-title").text('Change Username');			
			$( "#dialog-form" ).dialog( "open" );
		});
		
	$( "#change_password" )
		.click(function() {
			input_type = "change_password";
			$( ".validateTips" ).text("You can change the password as you wish");
			$( "#poll_input" ).attr("value",$( "#change_password" ).attr("title"));
			$("span.ui-dialog-title").text('Change Password');			
			$( "#dialog-form" ).dialog( "open" );
		});		
		
	$( "#edit_title" )
		.click(function() {
			input_type = "edit_title";
			$( ".validateTips" ).text("Change title name for the poll.");
			$( "#poll_input" ).attr("value",$( "#edit_title" ).attr("title"));
			$("span.ui-dialog-title").text('Edit Poll Title');			
			$( "#dialog-form" ).dialog( "open" );
		});
		
	$( "#edit_titlecolor" )
		.click(function() {
			input_type = "title_color";
			$( ".validateTips" ).text("Enter hex color code for the title.");	
			$( "#poll_input" ).attr("value","#"+$( "#edit_titlecolor" ).attr("title"));
			$("span.ui-dialog-title").text('Edit Title Color');
			$( "#dialog-form" ).dialog( "open" );
		});
		
	$( "#edit_bgcolor" )
		.click(function() {
			input_type = "bg_color";
			$( ".validateTips" ).text("Enter hex color code for the background of the poll.");
			$( "#poll_input" ).attr("value","#"+$( "#edit_bgcolor" ).attr("title"));
			$("span.ui-dialog-title").text('Edit Background Color');			
			$( "#dialog-form" ).dialog( "open" );
		});		
		
	$( "#new_poll" )
		.click(function() {
			input_type = "new_poll";
			$( "#dialog-form" ).dialog( "open" );
		});	

	$( "#new_website" )
		.click(function() {
			input_type = "new_website";
			$( "#dialog-form" ).dialog( "open" );
		});	
		
	$( "#new_option" )
		.click(function() {
			input_type = "new_option";
			$( ".validateTips" ).text("Enter option for the poll.");
			$("span.ui-dialog-title").text('Add New Option');			
			$( "#dialog-form" ).dialog( "open" );
		});						
		
	$(window).resize(function() {
	$( "#dialog-form" ).dialog("option", "position", "center");  
	});	
	
});